#!/usr/bin/perl

require "/news/lib/innshellvars.pl" ;

my $config="$inn::pathetc/autopilot.conf";			# The configuration file
my $counterfile="$inn::pathspool/counterchan/groupcounter";	# The groupcounter file
my $active="$inn::pathdb/active";				# The active file
my $checkgroupsdir="$inn::pathetc/checkgroups";			# The directory where the checkgroupsfilses lies
my $block_binary=1;						# Set to 1 if you want to set binary groups to "x"
my @binary=(
	'.*\.bain.*',
	'.*\.binar.*',
	'.*\.binaires.*',
	'.*\.biinar.*',
	'.*\.mp3.*',
	'.*\.pictures.*',
	'.*\.cd\.image.*',
);								# What are binarygroups	=> perl regex
my $fetch_http='/usr/local/bin/wget -q';			# How to fetch HTTP
my $docheckgroups="$inn::pathbin/docheckgroups";		# docheckgroups
my $syncgroups="$inn::pathbin/autopilot/syncgroups.pl";		# syncgroups.pl
my (%config,%unmanaged,%groups,@cgroupsi,@block_bins);

my $regex=join('|',@binary);

open(CONFIG, "< $config") or die "$0: can't open $config: $!\n";
while(chomp(my $line=<CONFIG>)) {
	next if $line =~ m/^\s*#/;
	next if $line =~ m/^$/;
	my @data=split(/:/,$line,4);
	# $data[0]=TLH pattern
	# $data[1]=Flag (i=ignore; w=watch; c=checkgroups; s=sync; h=http/ftp/wget)
	# $data[2]=min_articlecount to keep group; set to 0 to disable feature
	# $data[3]=url or checkgroupsfile

	$config{$data[0]}{'flag'}=$data[1];
	$config{$data[0]}{'count'}=$data[2];
	$config{$data[0]}{'url'}=$data[3];
}
close(CONFIG);

# Get all groups in active
if ( -s "$active" ) {
	open(ACTIVE, "< $active");
	while(chomp(my $line=<ACTIVE>)) {
		my @data=split(/\s+/,$line);
		# $data[0]=group
		# $data[1]=high
		# $data[2]=low
		# $data[3]=flag

		# Get the TLH (TopLevelHierarchy)
		my $tlh=(split(/\./, $data[0]))[0];

		if (exists $config{$tlh}) {
			$groups{$tlh}{$data[0]}{'count'}=$data[1]-$data[2];
			$groups{$tlh}{$data[0]}{'flag'}=$data[3];
			$groups{$tlh}{$data[0]}{'active'}=1;
		} else {
			$unmanaged{$tlh}++;
		}
	}
	close(ACTIVE);
}

# If we have a counterfile use these for the articlecounts
if ( -s "$counterfile" ) {
	open(COUNTERS, "< $counterfile");
	while(chomp(my $line=<COUNTERS>)) {
		my @data=split(/\s+/,$line);
		# $data[0]=articlecount
		# $data[1]=group

		# Get the TLH (TopLevelHierarchy)
		my $tlh=(split(/\./, $data[1]))[0];

		if (exists $config{$tlh}) {
			$groups{$tlh}{$data[1]}{'count'}+=$data[0];
		} else {
			$unmanaged{$tlh}++;
		}
	}
	close(COUNTERS);
}

foreach my $tlh (sort keys %config) {

	# Ignore TLH
	next if ($config{$tlh}{'flag'} eq 'i');

	my (@res,@raw,@cg,$file);
	if ($config{$tlh}{'flag'} eq 'c') {
		# We have a checkgroups file from somewhere
		$file="$checkgroupsdir/$config{$tlh}{'url'}";
	}
	elsif ($config{$tlh}{'flag'} eq 's') {
		# We have to sync against some newsserver
		@raw=`$syncgroups $config{$tlh}{'url'} 2>&1 | grep "^$tlh\." 2>&1`;
	}
	elsif ($config{$tlh}{'flag'} eq 'h') {
		# Get via HTTP
		@raw=`$fetch_http "$config{$tlh}{'url'}" -O - 2>&1 | grep "^$tlh\." 2>&1`;
	}
	elsif ($config{$tlh}{'flag'} eq 'w') {
		# Watch the traffic - works most reliable with a counterfile
		foreach my $group (sort keys %{$groups{$tlh}}) {
			push @cg, "# Watching $group traffic: counter=$groups{$tlh}{$group}{'count'} <-> limit=$config{$tlh}{'count'}\n";
			push @cg, "$inn::pathbin/ctlinnd -s rmgroup $group\n" if ($groups{$tlh}{$group}{'count'} < $config{$tlh}{'count'} && $groups{$tlh}{$group}{'active'});
			push @cg, "$inn::pathbin/ctlinnd -s newgroup $group y autopilot\n" if ($groups{$tlh}{$group}{'count'} >= $config{$tlh}{'count'} && !exists $groups{$tlh}{$group}{'active'});
		}
	}
	else { print "$tlh foo\n" }

	# We have RAW output: strip unwantet characters and save to $file
	if (scalar(@raw) >= 1) {
		# Parse the RAW output
		my @data;
		for my $line (@raw) {
			$line =~ s/^[\s\t]+//;	# strip leading spaces/tabs
			$line =~ s/\r//g;	# deDOS newline
			$line =~ s/\s+/\t/;	# convert spaces (between group ans tagline) into one  TAB
			push @data, $line;
		}

		$file="$checkgroupsdir/fetched_$tlh.checkgroups";
		open(CG, "> $file");
		for (@data) { print CG }
		close(CG);
		undef(@data);
	}
	undef(@raw);

	# Feed to $docheckgroups if we are not in watchmode and if a checkgroupsfile exists
	@cg=`$docheckgroups < $file 2>&1 | grep ctlinnd 2>&1` if ( -s "$file" && $config{$tlh}{'flag'} ne 'w');
	# Delete (temp) $file if exists and we are not ussing a "fix" checkgroupsfile
	unlink($file) if ( -s "$file" && $config{$tlh}{'flag'} ne 'c');

	for my $line (@cg) {
		$line =~ s/^[\s\t]+//; # Strip leading spaces
		push @res, $line;
		# If group is a binarygroup and we want to block them and command is not a rmgroup set groupmode to "x"
		my @data=split(/\s+/,$line);
		push @block_bins, "$inn::pathbin/ctlinnd -s changegroup $data[2] x\n" if ($block_binary && $line =~ m/$regex/i && $data[1] =~ /rmgroup/);
	}
	undef(@cg);

	# collect the ctlinnd lines
	push @cgroups, @res;
}

if (scalar(@cgroups) >= 1) {
	# We have something to do... throttle INN; do nasty things and let INN go again
	print "$inn::pathbin/ctlinnd throttle autopilot working\n";

	print " @cgroups";

	print "$inn::pathbin/ctlinnd go autopilot working\n";
}

if (scalar(@block_bins) >= 1) {
	# changegroup doesnt work with throttled or paused INN
	print "# Blocking binarys\n";
	print " @block_bins";
}

if (scalar(keys %unmanaged) >= 1) {
	print "# UNMANAGED HIERARCHIES\n";
	foreach my $tlh (sort keys %unmanaged) { print "# $tlh\n"; } 
}
