# nanoc-dejure

*nanoc* filter implementation of the *dejure.org*
[legal integration service](https://dejure.org/vernetzung.html),
adapted from the PHP reference implementation
at <https://dejure.org/vernetzung/vernetzungsfunktion.zip>.

This *nanoc* filter will add links to any references of German
(federal) law or jurisprudence to the corresponding bill or statute
or the appropriate case at the *dejure.org* legal information
service, using the public API of the legal integration service offered
by *dejure.org*. Results will be cached for (by default) 7 days to
reduce *nanoc* runtime.

## Installation / Usage

Just drop the `dejure.rb` file into your `lib/filters/` directory and
add the filter to a `compile` rule in your `Rules` file.

Please set the `base_url` of your site in the *nanoc.yaml*
configuration file, by adding e.g. `base_url: http://mysite.example`
at the end of the file. This is used as a service identification tag
when using the API.

The filter will use the `tmp/dejure-org/` directory for its cache.

Adding `<!-- no-dejure -->` somewhere in a source file will disable
the filter for that file.

## Parameters

This filter accepts the following parameters:

* `format` (`weit` or `schmal`, Default: `weit`)  
  Small (*schmal*) format will add the link just to the number of the
  article or section; wide (*weit*) format will add the link to the
  whole reference: "**§ 35** Abs. 1 StVO" or "**§ 35 Abs. 1 StVO**".

* `buzer` (`0` or `1`, Default: `1`)  
  If set to `true` (`1`) references to regulations not present at
  *dejure.org* will get a link to the *buzer.de* legal information
  service, covering all of the German Federal Law.

* `target` (Default: `''`)  
  Add this to the `target` attribute of the `<a>` elements that are
  generated by the API, e.g. `<a href="..." target="_blank">`.

* `class` (Default: `''`)  
  Add this to the `class` attribute of the `<a>` elements that are
  generated by the API, e.g. `<a href="..." class="_dejure">`.

* `cache_days` (Default: `7`)  
  The cache validity (in days).
