#!/bin/bash
# installation path is /srv/newsstats/, please adjust accordingly

# get month
MONTH=$1
if ! [[ $1 =~ [0-9]{4}-[0-9]{2} ]]; then
  MONTH=$(date -d "$(date +%Y-%m-15) -1 month" '+%Y-%m')
fi

# post stats
/srv/newsstats/bin/groupstats.pl --nocomments --sums --format dump --month $MONTH | /srv/newsstats/bin/postingstats.pl --month $MONTH | /srv/newsstats/contrib/tinews.pl -X -Y
/srv/newsstats/bin/hoststats.pl --nocomments --sums --format dump --month $MONTH | /srv/newsstats/bin/postingstats.pl -t server --month $MONTH | /srv/newsstats/contrib/tinews.pl -X -Y
/srv/newsstats/bin/clientstats.pl --nocomments --sums --versions --format dump --month $MONTH | /srv/newsstats/bin/postingstats.pl -t client --month $MONTH | /srv/newsstats/contrib/tinews.pl -X -Y
